<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Driver extends Model 
{

    protected $table = 'drivers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function team()
    {
        return $this->belongsTo('Team', 'team_id');
    }

    public function races()
    {
        return $this->belongsToMany('Race');
    }

    public function transmissionBox()
    {
        return $this->hasOne('TransmissionBox');
    }

}